@php
$dim = is_array($variant->dimensions ?? null)
    ? $variant->dimensions
    : json_decode($variant->dimensions ?? '{}', true);
@endphp

<form class="variant-form needs-validation mb-4" novalidate>
    @csrf

    <input type="hidden" name="product_id" value="{{ $product->id }}">

    <div class="card p-3 border">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h5 class="mb-0">
                Variant {{ $index + 1 }}
            </h5>

            @if(!empty($variant->id))
            <button type="button"
                class="btn btn-sm btn-outline-danger delete-variant"
                data-variant-id="{{ $variant->id }}">
                Delete
            </button>
            @endif
        </div>

        <div class="row g-3">

            <div class="col-md-4">
                <label>SKU *</label>
                <input type="text" name="sku"
                    value="{{ $variant->sku ?? '' }}"
                    class="form-control" required>
            </div>

            <div class="col-md-4">
                <label>Batch No</label>
                <input type="text" name="batch_no"
                    value="{{ $variant->batch_no ?? '' }}"
                    class="form-control">
            </div>

            <div class="col-md-4">
                <label>Unit *</label>
                <select name="unit" class="form-control" required>
                    @foreach(['cm','inch','mtr','sqft','nos'] as $unit)
                        <option value="{{ $unit }}"
                            {{ ($variant->unit ?? 'cm') === $unit ? 'selected' : '' }}>
                            {{ $unit }}
                        </option>
                    @endforeach
                </select>
            </div>

            <div class="col-md-2">
                <label>Length</label>
                <input type="number" name="dimensions[length]"
                    value="{{ $dim['length'] ?? '' }}"
                    class="form-control">
            </div>

            <div class="col-md-2">
                <label>Width</label>
                <input type="number" name="dimensions[width]"
                    value="{{ $dim['width'] ?? '' }}"
                    class="form-control">
            </div>

            <div class="col-md-2">
                <label>Height</label>
                <input type="number" name="dimensions[height]"
                    value="{{ $dim['height'] ?? '' }}"
                    class="form-control">
            </div>

            <div class="col-md-4">
                <label>Color Name</label>
                <input type="text" name="color_name"
                    value="{{ $variant->color_name ?? '' }}"
                    class="form-control">
            </div>

            <div class="col-md-2">
                <label>Color Code</label>
                <input type="color" name="color_code"
                    value="{{ $variant->color_code ?? '#000000' }}"
                    class="form-control">
            </div>

            <div class="col-md-2">
                <label>MRP *</label>
                <input type="number" name="mrp"
                    value="{{ $variant->mrp ?? '' }}"
                    class="form-control" required>
            </div>

            <div class="col-md-2">
                <label>Offer Price *</label>
                <input type="number" name="offer_price"
                    value="{{ $variant->offer_price ?? '' }}"
                    class="form-control" required>
            </div>

        </div>

        <div class="text-end mt-3">
            <button type="submit"
                class="btn btn-outline-primary btn-sm">
                Save Variant
            </button>
        </div>
    </div>
</form>
